-- Add default value on Frequency if it does not already exist
IF EXISTS 
(
	SELECT * FROM sys.columns AS c
	INNER JOIN sys.tables AS t ON c.[object_id]=t.[object_id] 
	WHERE t.[name]='QuotasAgent' AND c.[Name]='Frequency' AND [default_object_id]=0
) 
ALTER TABLE dbo.QuotasAgent ADD CONSTRAINT DF_QuotasAgent_Frequency DEFAULT 0 FOR Frequency
GO

UPDATE [QuotasAgent] SET [Frequency]=0 WHERE [Frequency] IS NULL
ALTER TABLE [QuotasAgent] ALTER COLUMN [Frequency] [int] NOT NULL
GO



